import java.util.TreeMap;
import java.util.HashMap;

import gurobi.GRB;
import gurobi.GRB.DoubleParam;
import gurobi.GRBEnv;
import gurobi.GRBException;
import gurobi.GRBLinExpr;
import gurobi.GRBModel;
import gurobi.GRBVar;

public class ILP_Solver
{
	class Row implements Comparable<Row>
	{
		private int r;

		public Row(int r)
		{
			this.r = r;
		}

		@Override
		public int compareTo(Row o)
		{
			if ( this.r == o.r )
				return 0;
			BinaryMatrix dmat = ILP_Solver.this.mat;
			for (int c = 0; c < dmat.getNoColumns(); c++)
			{
				if ( dmat.get(r, c) < dmat.get(o.r, c) )
					return -1;
				else if ( dmat.get(o.r, c) < dmat.get(r, c) )
					return 1;
			}
			return 0;
		}

	}

	static GRBEnv env;

	static
	{
		try
		{
			env = new GRBEnv(null);
			env.set(GRB.IntParam.OutputFlag, 0);
			env.set(DoubleParam.TimeLimit, 300);
		} catch (final GRBException e)
		{
			e.printStackTrace();
		}
	}

	private BinaryMatrix mat;
	
	private GRBModel model;

	private double time;

	private int noRowTypes;

	public double getPureSolvingTime()
	{
		return this.time;
	}

	public ILP_Solver(BinaryMatrix matrix)
	{
		this.mat = matrix;
	}

	public int getMinMod() throws GRBException
	{
		GRBModel model = this.getModel();
		long s = System.currentTimeMillis();
		model.optimize();
		this.time = (System.currentTimeMillis() - s) / 1000d;

		final int status = model.get(GRB.IntAttr.Status);
		if ( status == GRB.OPTIMAL )
			return (int) model.get(GRB.DoubleAttr.ObjVal);
		return -1;
	}

	private void computeModel() throws GRBException
    {
		this.model = new GRBModel(ILP_Solver.env);

		TreeMap<Row, Integer> map = new TreeMap<ILP_Solver.Row, Integer>();

		for (int r = 0; r < this.mat.getNoRows(); r++)
		{
			Row row = new Row(r);
			if ( !map.containsKey(row) )
				map.put(row, 0);
			map.put(row, map.get(row) + 1);

		}
		this.noRowTypes = map.size();

		int count = 0;
		TreeMap<Row, GRBVar> variableMap = new TreeMap<Row, GRBVar>();
		HashMap<GRBVar, Row> variableReMap = new HashMap<GRBVar, Row>();
		for (Row row : map.keySet())
		{
			GRBVar var = model.addVar(0, map.get(row), 1, GRB.INTEGER, "row_" + count++);
			variableMap.put(row, var);
			variableReMap.put(var, row);
		}
		model.update();

		for (int c = 0; c < this.mat.getNoColumns(); c++)
		{
			final GRBLinExpr expr = new GRBLinExpr();
			for (Row row : map.keySet())
			{
				if ( this.mat.get(row.r, c) == 0 )
				{
					expr.addTerm(1.0, variableMap.get(row));
				}
			}
			model.addConstr(expr, GRB.GREATER_EQUAL, this.mat.getGapForColumn(c), null);
		}
	}

	private GRBModel getModel() throws GRBException
	{
		if(this.model==null)
		{
			this.computeModel();
		}
		return this.model;
	}

	
	public int getNoOfRowTypes()
	{
		return this.noRowTypes;

	}
}