import gurobi.GRBException;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;

import benchmark.helpClasses.LogFileWriter;
import benchmark.helpClasses.StopWatch;

public class Main
{
	static DecimalFormat df = new DecimalFormat("00.##");

	public static void main(String[] args) throws IOException, GRBException
	{
		if ((args.length<1)||(args[0].isEmpty()))
		{
			System.err.println("USAGE:");
			System.err.println("java -jar ilp-solve.jar [instance-file]");
			System.err.println("     To solve an instance read from file.");
			System.err.println("     (Results collected in \"Lobbying_instance-files_log.dat\".)");
			System.err.println("java -jar ilp-solver.jar gaprandom");
			System.err.println("     Create and solve instance using column-based generator.");
			System.err.println("     (Results collected in \"Lobbying_gap-random_log.dat\".)");
			System.err.println("java -jar ilp-solver.jar floatrandom");
			System.err.println("     Create and solve instance using row-based generator.");
			System.err.println("     (Results collected in \"Lobbying_float-random_log.dat\".)");
			System.exit(-1);
		} else
		{
			if(args[0].toString().equalsIgnoreCase("gaprandom"))
			{
				MainGapRandom.main(null);
				System.exit(0);
			}
			if(args[0].toString().equalsIgnoreCase("floatrandom"))
			{
				MainFloatRandom.main(null);
				System.exit(0);
			}

			LogFileWriter w = new LogFileWriter("Lobbying_instance-files_log.dat", true, false);
			StopWatch watch = new StopWatch();
			watch.start();

			String instancePath = args[0].toString();
			Integer kFromHeader = new Integer(-2);
			BinaryMatrix binaryMatrix = new BinaryMatrix(instancePath, kFromHeader);
			//binaryMatrix.removeSatisfiedColumns();

			System.gc();

			// w.println("time to find matrix: " + (System.currentTimeMillis() -
			// st) / 1000d);

			ILP_Solver solver = new ILP_Solver(binaryMatrix);

			long s = System.currentTimeMillis();
			final int minMod = solver.getMinMod();
			double time = (System.currentTimeMillis() - s) / 1000d;

			//final String fileName = instancePath.substring( instancePath.lastIndexOf( "/" ) + 1, instancePath.lastIndexOf( "." ) );
			final String fileCounter = instancePath.substring( instancePath.lastIndexOf( "_" ) + 1, instancePath.lastIndexOf( "." ) );
			final String fileName = "m=" + df.format(binaryMatrix.getNoColumns()) + "_n="
					+ df.format(binaryMatrix.getNoRows()) + "_a=" + 0 + "_b=" + 0 + "_k=" + df.format(minMod)
					+ "_no=" + fileCounter;
			w.println(fileName + "_totalILPTime=" + time + "_solveILP=" + solver.getPureSolvingTime()
					+ "_noRowTypes=" + solver.getNoOfRowTypes() + "_gaps="
					+ Arrays.toString(binaryMatrix.getGaps()));
			w.flush();
			writefile(binaryMatrix, fileName, minMod);
			w.close();
		}
	}

	private static void writefile(BinaryMatrix binaryMatrix, final String fileName, int k) throws IOException
	{
		FileWriter writer = new FileWriter(new File("./instances/" + fileName + ".dat"));
		writer.write("# k=" + k + ",m=" + binaryMatrix.getNoColumns() + ",n=" + binaryMatrix.getNoRows() + "\n");
		writer.write(binaryMatrix.toString());
		writer.flush();
		writer.close();
	}
}
