import gurobi.GRBException;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;

import benchmark.helpClasses.LogFileWriter;
import benchmark.helpClasses.StopWatch;

public class MainFloatRandom
{
	static DecimalFormat df = new DecimalFormat("00.##");

	public static void main(String[] args) throws IOException, GRBException
	{
		final float[] aArr = { 0.1f, 0.2f, 0.3f, 0.4f };
		final float[] bArr = { 0.5f, 0.6f, 0.65f, 0.7f, 0.8f };

		LogFileWriter w = new LogFileWriter("Lobbying_float-random_log.dat", false, false);
		StopWatch watch = new StopWatch();
		watch.start();
		long fileCounter = 1;
		int maxRowColumn = 1000;
		for (int noColumns = 77; noColumns <= maxRowColumn; noColumns = (int) Math.ceil(noColumns * 1.1))
		{
			final int min = 10;
			final int max = noColumns < 10 ? (int) Math.pow(2, 1 + noColumns) : maxRowColumn;
			final int steps = Math.max((max - min) / 100, 1);
			for (int noRows = min; noRows < max; noRows += steps)
				for (int iter = 0; iter < 2; iter++)
					for (float a : aArr)
						for (float b : bArr)
							if ( a <= b && (a + b) / 2f < 0.5f )
							{
								BinaryMatrix binaryMatrix = new BinaryMatrix(noRows, noColumns, a, b);
								binaryMatrix.reassignSatisfiedColumns(a, b);

								System.gc();

								ILP_Solver solver = new ILP_Solver(binaryMatrix);

								long s = System.currentTimeMillis();
								final int minMod = solver.getMinMod();
								double time = (System.currentTimeMillis() - s) / 1000d;

								final String fileName = "m=" + df.format(binaryMatrix.getNoColumns()) + "_n="
										+ df.format(binaryMatrix.getNoRows()) + "_a=" + a + "_b=" + b + "_k=" + df.format(minMod)
										+ "_no=" + fileCounter++;
								writefile(fileCounter, binaryMatrix, fileName, minMod);
								w.println(fileName + "_totalILPTime=" + time + "_solveILP=" + solver.getPureSolvingTime()
										+ "_noRowTypes=" + solver.getNoOfRowTypes() + "_gaps="
										+ Arrays.toString(binaryMatrix.getGaps()));
								w.flush();
							}
		}
		w.close();
	}

	private static void writefile(long fileCounter, BinaryMatrix binaryMatrix, final String fileName, int k) throws IOException
	{
		FileWriter writer = new FileWriter(new File("./instances/" + fileName + ".dat"));
		writer.write("# k=" + k + ",m=" + binaryMatrix.getNoColumns() + ",n=" + binaryMatrix.getNoRows() + "\n");
		writer.write(binaryMatrix.toString());
		writer.flush();
		writer.close();
	}
}
