import gurobi.GRBException;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;

import benchmark.helpClasses.LogFileWriter;
import benchmark.helpClasses.StopWatch;

public class MainGapRandom
{
	static DecimalFormat df = new DecimalFormat("00.##");

	final static int maxRowColumn = 1000;

	public static void main(String[] args) throws IOException, GRBException
	{
		// gap is uniformly chosen between a and b percent of the maximum gap
		final float[] aArr = { 0f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f };
		final float[] bArr = { 0.05f, 0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1f };

		LogFileWriter w = new LogFileWriter("Lobbying_gap-random_log.dat", false, true);
		StopWatch watch = new StopWatch();
		watch.start();
		long fileCounter = 1;

		for (int noColumns = 41; noColumns <= maxRowColumn; noColumns = (int) Math.ceil(noColumns * 1.1))
		{
			System.out.println("m=" + noColumns);
			final int min = 10;
			final int max = noColumns < 10 ? (int) Math.pow(2, 1 + noColumns) : maxRowColumn;
			final int steps = Math.max((max - min) / 100, 1);
			for (int noRows = min; noRows < max; noRows += steps)
			{
				System.out.println("n=" + noRows);
				for (int iter = 0; iter < 2; iter++)
					for (float a : aArr)
						for (float b : bArr)
							if ( a <= b && b <= 1f )
							{
								final int maj = noRows / 2 + 1;

								final int minGap = Math.max(Math.round(a * maj), 1);
								final int maxGap = Math.max(1, Math.min(maj, Math.round(b * maj)));

								BinaryMatrix binaryMatrix = new BinaryMatrix(noRows, noColumns, minGap, maxGap);
								binaryMatrix.reassignSatisfiedColumns(a, b);

								System.gc();

								ILP_Solver solver = new ILP_Solver(binaryMatrix);

								long s = System.currentTimeMillis();
								final int minMod = solver.getMinMod();
								double time = (System.currentTimeMillis() - s) / 1000d;

								final String fileName = "m=" + df.format(binaryMatrix.getNoColumns()) + "_n="
										+ df.format(binaryMatrix.getNoRows()) + "_a=" + a + "_b=" + b + "_minGap=" + minGap
										+ "_maxGap=" + maxGap + "_k=" + df.format(minMod) + "_no=" + fileCounter++;
								writefile(fileCounter, binaryMatrix, fileName, minMod);
								w.println(fileName + "_totalILPTime=" + time + "_solveILP=" + solver.getPureSolvingTime()
										+ "_noRowTypes=" + solver.getNoOfRowTypes() + "_gaps="
										+ Arrays.toString(binaryMatrix.getGaps()));
								w.flush();
							}
			}
		}
		w.close();
	}

	private static void writefile(long fileCounter, BinaryMatrix binaryMatrix, final String fileName, int k) throws IOException
	{
		FileWriter writer = new FileWriter(new File("./instances/" + fileName + ".dat"));
		writer.write("# k=" + k + ",m=" + binaryMatrix.getNoColumns() + ",n=" + binaryMatrix.getNoRows() + "\n");
		writer.write(binaryMatrix.toString());
		writer.flush();
		writer.close();
	}
}
