#!/usr/bin/perl
use strict;
use POSIX;
use List::Util qw(min);
use warnings;
use diagnostics;

# Given a directory, create two debug outputs for the evaluation
# Or given three debug outputs: 1) greedy debug, 2) ilp debug, and 3) stupid debug, combine these three debug outputs.

# GLOBAL VARS
my $no_rows; # number of rows
my $no_cols; # number of columns
my $argc = 0;  # argument counter
my $max_ones_per_vote = 0; # maximal number of ones per vote.
my @bmatrix; # binary matrix


sub usage{
    print STDERR "************************************************************\n";
    print STDERR "* usage: evaluation.pl [-s] dir\n";
    print STDERR "* usage: evaluation.pl gd_debug ilp_debug stupid_debug\n";
    print STDERR "************************************************************\n";
}

sub failure{
    my $failedparm = shift;

    if( defined $failedparm ){
        print STDERR "$failedparm format is wrong\n";
    }else{
        print STDERR "parameters failed\n";
    }

    &usage;
    print STDERR "Please see the usage for more details.\n";
    die "aborting.";
}


my $stupid = "";

if($ARGV[0] =~ "-s"){
    $stupid = "-s";
    shift;
}

# sanity check!
if (@ARGV != 3 && @ARGV != 1) {&failure;}

if (@ARGV == 1){
    my $dir = $ARGV[0];
    my %dimensions;

    my @files = `/bin/ls $dir`;
    foreach my $file (@files){
	if($file =~ /m=(\d+)\_n=(\d+)\_a=([\.\d]+)\_b=([\.\d]+).*\_k=([-\d]+)\_no=(\d+)/){
	    # $2 = m, $1=n, $6 = file number
	    $dimensions{$2}{$1}{$6}{a} = $3; 
	    $dimensions{$2}{$1}{$6}{b} = $4;
	    $dimensions{$2}{$1}{$6}{k} = $5;
	}
    }

    my $debug_file = "${dir}\/gd_debug_detailed.txt";
    my $debug_abbrv = "${dir}\/gd_debug_abbrv.txt";

    if($stupid =~ "-s"){
        $debug_file = "${dir}\/stupid_debug_detailed.txt";
        $debug_abbrv = "${dir}\/stupid_debug_abbrv.txt";
    }

    open (F, ">>${debug_file}") || die "cannot open file ${debug_file} f\n";
    open (ABBRV, ">>${debug_abbrv}") || die "cannot open file ${debug_file} f\n";
#print F "dd\n";
    
    print F "########## FORMAT ###########\n";
    print F "# CASE n=%d m=%d\n";
    print F "# file: file_name\n";
    print F "# k_GD k_ILP time_GD\n";
    print F "# max_gap gap_vector\n";
    foreach my $n (sort keys %dimensions){
    foreach my $m (sort keys %{$dimensions{$n}}){
#	print STDOUT "n=$n, m=$m\n";
	open(F, ">>${debug_file}") || die "cannot open file ${debug_file} f\n";
	print F "CASE n=$n m=$m\n";
	print "CASE n=$n m=$m\n";
#	print "CASE n=$n m=$m\n";
	my @files = `/bin/ls $dir/m=$m\_n=$n*\.dat`;
	foreach my $file (@files){
	    chop($file);
	    if ($file =~ /$m\_n=$n.*\_no=(\d+)\.dat/){
		my $no = $1;
		if( ! exists $dimensions{$n}{$m}{$no} ) {next;} 
		
		########## GD ABBRV DEBUG OUTPUT FORMAT ###########
		########## STUPID ABBRV DEBUG OUTPUT FORMAT ###########
                # file_name n m a b k_GD k_ILP solve_time_GD total_time_GD max_gap gap_vector
                # file_name n m a b k_ST k_ILP solve_time_ST total_time_ST max_gap gap_vector
		print F "file: ${file}\n";
	#	print "file: ${file}\n";
		print ABBRV "$file $n $m $dimensions{$n}{$m}{$no}{a} $dimensions{$n}{$m}{$no}{b} ";

                my @output=`./ols $stupid $file`;

		my $solution = pop(@output);
		#	print "$solution $dimensions{$n}{$m}{$no}{t}\n";
		chop($solution);
		print F "$solution ";
		print ABBRV "$solution ";

		my $gaps;
		if(@output == 2){
		    my $bad_msg = pop(@output);
	#	    print "${bad_msg}";
		    print F "\n${bad_msg}";
		}

		$gaps = pop(@output);

		print ABBRV "${gaps}";
		print F "${gaps}";
	    }
	}
	print F "\n";
    }
}

close(F);
close(ABBRV);

}else{
    my $gd_debug = $ARGV[0];
    my $ilp_debug = $ARGV[1];
    my $stupid_debug = $ARGV[2];

    my %ilp_durations; # key is the number index of an instance
    my %stupid_durations; # key is the number index of an instance

    ############## READ ILP DEBUG OUTPUTs ##################################
    open(ILPIN, "${ilp_debug}")  || die "cannot open file ${ilp_debug}\n";;
    while(<ILPIN>){
	# ILP file format:
	# m=(..)_n=(..)_a=(..)_b=(..)_k=(..)_no=(..)_ilPTime=(..)_solveILP=(..)
	if(/.*no=(\d+).*totalILPTime=([\d\.]+)\_solveILP=([\d\.]+)/)
	{
	    $ilp_durations{$1}{total} = $2;
	    $ilp_durations{$1}{solve} = $3;
	}
    }
    close(ILPIN);
    ########################################################################
    

    ############## READ STUPID DEBUG OUTPUTs ###############################
    open(STUPIDIN, "${stupid_debug}") || 
	die "cannot open file ${ilp_debug}\n";;
    while(<STUPIDIN>){
	# stupid file format:
	# file_name n m a b k_STUPID k_ILP solve_time_STUPID total_time_STUPID max_gap gap_vector
	my @terms = split(/ /, $_);
	if(@terms < 11){ next; }
#	print "file: $terms[0], ";
	if($terms[0] =~ /no=(\d+)\.dat/) {
	    my $number = $1;
	    my $solve_time = $terms[7];
	    my $total_time = $terms[8];
	    my $stupid_k = $terms[5];
	    $stupid_durations{$number}{total} = $total_time;
	    $stupid_durations{$number}{solve} = $solve_time;	    
	    $stupid_durations{$number}{k} = $stupid_k;	    
	}
    }
    close(STUPIDIN);
    ########################################################################


    open(GDIN, "${gd_debug}")  || die "cannot open file ${gd_debug} f\n";;
    my $path = `dirname ${gd_debug}`;
    chop($path);
    # my $output = "${path}\/debug\_abbrv\.txt";
    
    # open(OUT, ">${output}") || die "cannot open file ${output}\n";
    # GD file format:
    # file_name n m a b k_GD k_ILP solve_time_GD total_time_GD max_gap gap_vector
    while(<GDIN>){
	my @terms = split(/ /, $_);
	if(@terms < 11){ next; }
	my $number = -1;
	if($terms[0] =~ /no=(\d+)\.dat/) {
	    $number = $1;
	}
	if(! exists $ilp_durations{$number} || 
	   ! exists $stupid_durations{$number}){
	    print STDOUT "Number ${number} doesn't exist!\n";
	    next; 
	}
#	print "file: $terms[0], ";
#	print "number: ${number}\n";
	print STDOUT $terms[0] . " " . $terms[1] . " ";
	print STDOUT $terms[2] . " " . $terms[3] . " " . $terms[4] . " " . $terms[5] . " " . $terms[6] . " " . $stupid_durations{$number}{k} . " ";
	print STDOUT $terms[7] . " " . $ilp_durations{$number}{solve} . " " . $stupid_durations{$number}{solve} . " ";
	print STDOUT  $terms[8] . " " . $ilp_durations{$number}{total} . " " . $stupid_durations{$number}{total};
	for(my $i = 9; $i < @terms; $i++){
	    print STDOUT " " .$terms[$i];
	}
#	print OUT "\n";
    }

    close(GDIN);
    #close(OUT)
}




