// New binary matrix class for the new algorithm

#ifndef __MATRIX_H
#define __MATRIX_H

#include <vector>
using namespace std;

class cMatrix {
private:
  unsigned m_nCols;  // number of columns
  unsigned m_nRows;  // number of rows

  // We operate mostly on columns, so we uses columns as our outer storage
  // layer
  vector<int>** m_data;

  // gaps
  int* m_gaps;
public:
  cMatrix(const cMatrix&);
  cMatrix(unsigned nRows, unsigned nCols);
  ~cMatrix();

  // getters/setters
  unsigned getNRows() const { return m_nRows; }
  unsigned getNCols() const { return m_nCols; }
  int getElem(unsigned row, unsigned col) const {
    assert(row < m_nRows);
    assert(col < m_nCols);
    return (*m_data[col])[row];
  }
  void setElem(unsigned row, unsigned col, int val);
  void setCol(unsigned col, const vector<int>& data);
  
  // set the values of the matrix to be zero
  void resetMatrix(void);
  // lobbying-specific methods
  // update gap values
  void computeGaps();
  // remove all columns with gaps <= 0
  void purgeSatisfiedCols();
  // get gap values
  int getGap(unsigned col) const { assert(col < m_nCols); return m_gaps[col]; }
  // set a row to have all 1s; will update the gap values
  void bribeRow(unsigned row);
  
  // check whether the matrix has two identical columns.
  bool has_identical_col();

  // debug output
  void dump() const;
  void gaps() const;
};

#endif // __MATRIX_H
