#!/usr/bin/perl
use strict;
use POSIX;
use List::Util qw(min);
use File::Temp;
use File::Path qw(make_path);

# Given a size n and m, and print randomized binary n by m matrices;

# GLOBAL VARS
my $no_rows; # number of rows
my $no_cols; # number of columns
my $argc = 0;  # argument counter
my $max_ones_per_vote = 0; # maximal number of ones per vote.
my @bmatrix; # binary matrix
my @column_types; # a hash storing the valid  column types.
                  # A column type is valid if it has at least one 1-entry,
                  # and maximal floor{n/2} 1-entries.  

sub usage{
    print STDERR "************************************************************\n";
    print STDERR "* usage: bmatrix.pl [--s <max._#ones_per_vote>] #rows #cols\n";
    print STDERR "************************************************************\n";
}

sub failure{
    my $failedparm = shift;

    if( defined $failedparm ){
        print STDERR "$failedparm format is wrong\n";
    }else{
        print STDERR "parameters failed\n";
    }

    &usage;
    print STDERR "Please see the usage for more details.\n";
    die "aborting.";
}

sub rand_from_ints_set{
    my $ints_set = shift;
    my @arr = %$ints_set;
    my $random_number = int(rand($#arr+1));
    $arr[$random_number];
}

sub ctypes{
    my $ones = shift;
    my $n = shift;
    my $aref = shift;
#    print "number ones: $ones, n: $n\n";
    
    if($ones < 0){
        return $aref;
    }
    if( $ones >= $n ){
        my @tmp = (0 .. $n-1);
        push(@$aref, [@tmp]);
        return $aref;
    }
    my @aref0 = @$aref;

    # Recursion two cases:
    # case 0: (ones, n) = (ones, n-1)
    $n--;
    my $t0ref = ctypes($ones, $n, \@aref0);
    # case 1: (ones, n) = (ones-1, n-1) + [n-1]
    my $t1ref = ctypes($ones-1, $n, \@$aref);
    foreach my $item (@$t1ref){
        push(@$item, $n);
    }
    push(@$t1ref, @$t0ref);
    return $t1ref;
}

sub mtypes{
    my $ones = shift;
    my $n = shift;
    my $aref = shift;
    my $path_name = shift;
    my $counter = shift;
#    print "number ones: $ones, n: $n\n";

    if( $ones <= 0 || $ones >= $n ){
        print ">=, ones: $ones, n: $n\n";
        my @matrix;
        for(my $r = 0; $r < $no_rows; $r++){
            my $col = 0;
            foreach my $item (@$aref){
                $matrix[$r][$col++] = $column_types[$item][$r];
            }
        }
        if($ones > 0){
            for(my $r = 0; $r < $no_rows; $r++){
                for(my $i = $no_cols-$n; $i < $no_cols; $i++){
                    $matrix[$r][$i] = $column_types[$i][$r];
                }
            }
        }
        my $file_name = "./${path_name}/m${no_rows}x${no_cols}.${counter}";
        write_matrix($file_name, $no_rows, $no_cols, \@matrix);
        system("")
        return ++$counter;
    }
    my @aref0 = @$aref;

    # Recursion two cases:
    # case 0: (ones, n) = (ones, n-1)
    $n--;
    my $c = mtypes($ones, $n, \@aref0, $path_name, $counter);
    # case 1: (ones, n) = (ones-1, n-1) + [n-1]
    push(@$aref, $n);
    mtypes($ones-1, $n, \@$aref, $path_name, $c);
}

sub all_ctypes{
    my $n = shift;
    my $t = floor($n/2) + 1;
    my @columns;
    
    my $counter = 0;
    for(my $i = 1; $i < $t; $i++ ){
        my @types;
        my $ref = ctypes($i, $n, \@types);
        foreach my $x (@$ref){
            my @dd = sort { $a <=> $b } @$x;
            my $c = 0;
            for(my $j = 0; $j < $n; $j++){
                if($j == $x->[$c]){
                    print "1 ";
                    $c++;
                    $columns[$counter][$j] = 1;
                }else{
                    print "0 ";
                    $columns[$counter][$j] = 0;
                }
            }
            print "\n";
            $counter++;
        }
    }
    return \@columns;
}


sub write_matrix{
    my $file_name = shift;
    my $n = shift;
    my $m = shift;
    my $arr = shift;
    
    open(TMPDATA, ">${file_name}");
    for(my $i = 0; $i < $n; $i++){
        print TMPDATA "@{$arr->[$i]}\n";
        # for(my $j = 0; $j < $m; $j++){
        # }
#        print TMPDATA "\n";
    }
    close(TMPDATA);
}

sub binomial {
    use bigint;
    my ($r, $n, $k) = (1, @_);
    for (1 .. $k) { $r *= $n + 1 - $_, $r /= $_ }
    $r;
}

# sanity check
if( @ARGV != 2 && @ARGV != 4 ) { &failure; }

# parse input parameters

# check options;

if( $ARGV[$argc] eq "--s"){
    $argc++;
    $max_ones_per_vote = $ARGV[$argc++];    
    if($max_ones_per_vote < 0){
	&failure("The parameter max. number of ones per vote (${max_ones_per_vote}) should be non negative!\n");
    }
}

$no_rows = $ARGV[$argc++];
if($no_rows < 0){
    &failure("The parameter number of rows (${no_rows}) should be positive integer!\n");
}

$no_cols = $ARGV[$argc++];
if($no_cols < 0){
    &failure("The parameter number of columns (${no_cols}) should be positive integer!\n");
}

if( ${no_cols} < $max_ones_per_vote ){
    #print STDOUT "// Max. number of ones per vote (${max_ones_per_vote}) is greater than the number of columns (${no_cols}). Now set the max. number of ones per vote to be ${no_cols}.\n";
    ${max_ones_per_vote} = ${no_cols};
}


my $types = all_ctypes($no_rows); 
@column_types = @$types;

print "--------------------\n";

my $size = $#column_types+1;
my $tmp_c = 0;
foreach my $x (@column_types){
    print $tmp_c . ": ";
    $tmp_c++;
    foreach my $y (@$x){
        print "$y ";
    }
    print "\n";
}

my @matrices = ();
my $path_name = "./matrix_${no_rows}x${no_cols}";
make_path(${path_name});
mtypes($no_cols, $size, \@matrices, $path_name, 0);

# my $file_counter = 0;
# foreach my $tmp_item (@$tmp_ref){
#     my $path_name = "./matrix_${no_rows}x${no_cols}";
#     make_path(${path_name});
#     my $tmp_file ="./${path_name}/m${no_rows}x${no_cols}.${file_counter}";
#     open(TMPDATA, ">${tmp_file}");
#     print TMPDATA "${no_rows} ${no_cols}\n";
#     my @arr;
#     my $c = 0;
#     foreach my $index (@${tmp_item}){
#         my $col = $column_types[$index];
#         for(my $i = 0; $i < $no_rows; $i++){
#             $arr[$i][$c] = $col->[$i];
# #            print $col->[$i] . " ";
#         }
# #        print "\n";
#         $c++;
#     }
#     for(my $i = 0; $i < $no_rows; $i++){
#         for(my $j = 0; $j < $no_cols; $j++){
#             print TMPDATA $arr[$i][$j] . " ";
#         }
#         print TMPDATA "\n";
#     }
#     $file_counter++;
# }
